IF EXISTS (SELECT * FROM SYS.views WHERE NAME = 'V_EST_PROD_TBL_FIDEL')
BEGIN
	DROP VIEW V_EST_PROD_TBL_FIDEL;
END
GO

CREATE VIEW
	[dbo].[V_EST_PROD_TBL_FIDEL]
AS	

--PEGANDO A PONTUAO POR PRODUTO
SELECT
	TP.CD_PROD,
	TFIL.CD_FILIAL,
	T.CD_TBL_FIDEL,

	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	ELSE
		COALESCE(TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	END AS CD_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	ELSE
		COALESCE(TBL_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	END AS DS_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TIPO_PROMOCAO IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TIPO_PROMOCAO, 0)
	ELSE
		COALESCE(TBL_AD.CD_TIPO_PROMOCAO, 0)
	END AS CD_TIPO_PROMOCAO,

	CASE WHEN PROD_AD.CD_FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.CD_FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.CD_FATOR_PONTOS, 0)
	END AS CD_FATOR_PONTOS,

	CASE WHEN PROD_AD.FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.FATOR_PONTOS, 0)
	END AS FATOR_PONTOS,

	CASE WHEN PROD_AD.VLR_MINIMO IS NOT NULL THEN
		COALESCE(PROD_AD.VLR_MINIMO, 0)
	ELSE
		COALESCE(TBL_AD.VLR_MINIMO, 0)
	END AS VLR_MINIMO,

	CASE WHEN PROD_AD.QTDE_MINIMA IS NOT NULL THEN
		COALESCE(PROD_AD.QTDE_MINIMA, 0)
	ELSE
		COALESCE(TBL_AD.QTDE_MINIMA, 0)
	END AS QTDE_MINIMA,

	CASE WHEN PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD_DIA.DIA, 0)
	ELSE
		COALESCE(TBL_AD_DIA.DIA, 0)
	END AS DIA_SEMANA,

	CASE WHEN PROD_AD.DT_INI IS NOT NULL THEN
		COALESCE(PROD_AD.DT_INI, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_INI, '20000101')
	END AS D1,

	CASE WHEN PROD_AD.DT_FIM IS NOT NULL THEN
		COALESCE(PROD_AD.DT_FIM, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_FIM, '20000101')
	END AS D2,

	CASE WHEN PROD_AD.CD_USU IS NOT NULL THEN
		COALESCE(PROD_AD.CD_USU, 0)
	ELSE
		COALESCE(TBL_AD.CD_USU, 0)
	END AS CD_USU,

	CASE WHEN PROD_AD.DT_CAD IS NOT NULL THEN
		COALESCE(PROD_AD.DT_CAD, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_CAD, '20000101')
	END AS DT_CAD,

	CASE WHEN PROD_AD.DT_ULT_ALT IS NOT NULL THEN
		COALESCE(PROD_AD.DT_ULT_ALT, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_ULT_ALT, '20000101')
	END AS DT_ULT_ALT
FROM
	EST_PROD_TBL_FIDEL T
	INNER JOIN EST_PROD_TBL_FIDEL_PRC_FILIAL TFIL ON
		T.CD_EMP = TFIL.CD_EMP
		AND T.CD_TBL_FIDEL = TFIL.CD_TBL_FIDEL
	INNER JOIN EST_PROD_TBL_FIDEL_EST_PROD TP ON
		T.CD_EMP = TP.CD_EMP
		AND T.CD_TBL_FIDEL = TP.CD_TBL_FIDEL
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL TBL_AD ON
		T.CD_EMP = TBL_AD.CD_EMP
		AND T.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA TBL_AD_DIA ON
		TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL PROD_AD ON
		TP.CD_EMP = PROD_AD.CD_EMP
		AND TP.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA PROD_AD_DIA ON
		PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
WHERE
	TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL OR PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL


UNION


--PEGANDO A PONTUAO POR FAMLIA
SELECT
	ARV.CD_PROD,
	TFIL.CD_FILIAL,
	T.CD_TBL_FIDEL,
	
	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	ELSE
		COALESCE(TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	END AS CD_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	ELSE
		COALESCE(TBL_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	END AS DS_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TIPO_PROMOCAO IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TIPO_PROMOCAO, 0)
	ELSE
		COALESCE(TBL_AD.CD_TIPO_PROMOCAO, 0)
	END AS CD_TIPO_PROMOCAO,

	CASE WHEN PROD_AD.CD_FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.CD_FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.CD_FATOR_PONTOS, 0)
	END AS TIPO_PONTUACAO,

	CASE WHEN PROD_AD.FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.FATOR_PONTOS, 0)
	END AS FATOR_PONTUACAO,

	CASE WHEN PROD_AD.VLR_MINIMO IS NOT NULL THEN
		COALESCE(PROD_AD.VLR_MINIMO, 0)
	ELSE
		COALESCE(TBL_AD.VLR_MINIMO, 0)
	END AS VLR_MINIMO,

	CASE WHEN PROD_AD.QTDE_MINIMA IS NOT NULL THEN
		COALESCE(PROD_AD.QTDE_MINIMA, 0)
	ELSE
		COALESCE(TBL_AD.QTDE_MINIMA, 0)
	END AS QTDE_MINIMA,

	CASE WHEN PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD_DIA.DIA, 0)
	ELSE
		COALESCE(TBL_AD_DIA.DIA, 0)
	END AS DIA_SEMANA,

	CASE WHEN PROD_AD.DT_INI IS NOT NULL THEN
		COALESCE(PROD_AD.DT_INI, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_INI, '20000101')
	END AS D1,

	CASE WHEN PROD_AD.DT_FIM IS NOT NULL THEN
		COALESCE(PROD_AD.DT_FIM, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_FIM, '20000101')
	END AS D2,

	CASE WHEN PROD_AD.CD_USU IS NOT NULL THEN
		COALESCE(PROD_AD.CD_USU, 0)
	ELSE
		COALESCE(TBL_AD.CD_USU, 0)
	END AS CD_USU,

	CASE WHEN PROD_AD.DT_CAD IS NOT NULL THEN
		COALESCE(PROD_AD.DT_CAD, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_CAD, '20000101')
	END AS DT_CAD,

	CASE WHEN PROD_AD.DT_ULT_ALT IS NOT NULL THEN
		COALESCE(PROD_AD.DT_ULT_ALT, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_ULT_ALT, '20000101')
	END AS DT_ULT_ALT
FROM
	EST_PROD_TBL_FIDEL T
	INNER JOIN EST_PROD_TBL_FIDEL_PRC_FILIAL TFIL ON
		T.CD_EMP = TFIL.CD_EMP
		AND T.CD_TBL_FIDEL = TFIL.CD_TBL_FIDEL
	INNER JOIN EST_PROD_TBL_FIDEL_EST_ARV_MERC_FAMILIA TP ON
		T.CD_EMP = TP.CD_EMP
		AND T.CD_TBL_FIDEL = TP.CD_TBL_FIDEL
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
		TP.CD_EMP = ARV.CD_EMP
		AND TP.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL TBL_AD ON
		T.CD_EMP = TBL_AD.CD_EMP
		AND T.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA TBL_AD_DIA ON
		TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL PROD_AD ON
		TP.CD_EMP = PROD_AD.CD_EMP
		AND TP.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA PROD_AD_DIA ON
		PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
WHERE
	TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL OR PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_PROD
		WHERE
			CD_EMP = ARV.CD_EMP
			AND CD_TBL_FIDEL = TP.CD_TBL_FIDEL
			AND CD_PROD = ARV.CD_PROD)
	

UNION		


--PEGANDO A PONTUAO POR MARCA
SELECT
	ARV.CD_PROD,
	TFIL.CD_FILIAL,
	T.CD_TBL_FIDEL,
	
	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	ELSE
		COALESCE(TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	END AS CD_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	ELSE
		COALESCE(TBL_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	END AS DS_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TIPO_PROMOCAO IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TIPO_PROMOCAO, 0)
	ELSE
		COALESCE(TBL_AD.CD_TIPO_PROMOCAO, 0)
	END AS CD_TIPO_PROMOCAO,

	CASE WHEN PROD_AD.CD_FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.CD_FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.CD_FATOR_PONTOS, 0)
	END AS TIPO_PONTUACAO,

	CASE WHEN PROD_AD.FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.FATOR_PONTOS, 0)
	END AS FATOR_PONTUACAO,

	CASE WHEN PROD_AD.VLR_MINIMO IS NOT NULL THEN
		COALESCE(PROD_AD.VLR_MINIMO, 0)
	ELSE
		COALESCE(TBL_AD.VLR_MINIMO, 0)
	END AS VLR_MINIMO,

	CASE WHEN PROD_AD.QTDE_MINIMA IS NOT NULL THEN
		COALESCE(PROD_AD.QTDE_MINIMA, 0)
	ELSE
		COALESCE(TBL_AD.QTDE_MINIMA, 0)
	END AS QTDE_MINIMA,

	CASE WHEN PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD_DIA.DIA, 0)
	ELSE
		COALESCE(TBL_AD_DIA.DIA, 0)
	END AS DIA_SEMANA,

	CASE WHEN PROD_AD.DT_INI IS NOT NULL THEN
		COALESCE(PROD_AD.DT_INI, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_INI, '20000101')
	END AS D1,

	CASE WHEN PROD_AD.DT_FIM IS NOT NULL THEN
		COALESCE(PROD_AD.DT_FIM, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_FIM, '20000101')
	END AS D2,

	CASE WHEN PROD_AD.CD_USU IS NOT NULL THEN
		COALESCE(PROD_AD.CD_USU, 0)
	ELSE
		COALESCE(TBL_AD.CD_USU, 0)
	END AS CD_USU,

	CASE WHEN PROD_AD.DT_CAD IS NOT NULL THEN
		COALESCE(PROD_AD.DT_CAD, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_CAD, '20000101')
	END AS DT_CAD,

	CASE WHEN PROD_AD.DT_ULT_ALT IS NOT NULL THEN
		COALESCE(PROD_AD.DT_ULT_ALT, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_ULT_ALT, '20000101')
	END AS DT_ULT_ALT
FROM
	EST_PROD_TBL_FIDEL T
	INNER JOIN EST_PROD_TBL_FIDEL_PRC_FILIAL TFIL ON
		T.CD_EMP = TFIL.CD_EMP
		AND T.CD_TBL_FIDEL = TFIL.CD_TBL_FIDEL
	INNER JOIN EST_PROD_TBL_FIDEL_EST_MC TM ON
		T.CD_EMP = TM.CD_EMP
		AND T.CD_TBL_FIDEL = TM.CD_TBL_FIDEL
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
		TM.CD_EMP = ARV.CD_EMP
		AND TM.CD_MC = ARV.CD_MC
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL TBL_AD ON
		T.CD_EMP = TBL_AD.CD_EMP
		AND T.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA TBL_AD_DIA ON
		TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL PROD_AD ON
		TM.CD_EMP = PROD_AD.CD_EMP
		AND TM.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA PROD_AD_DIA ON
		PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
WHERE
	TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL OR PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL
	
	--ELIMINANDO OS REGISTROS POR FAMILIA
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_ARV_MERC_FAMILIA TF
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV2 ON
				TF.CD_EMP = ARV2.CD_EMP
				AND TF.CD_ARV_MERC_FAMILIA = ARV2.CD_ARV_MERC_FAMILIA
				
		WHERE
			T.CD_EMP = TF.CD_EMP
			AND T.CD_TBL_FIDEL = TF.CD_TBL_FIDEL
			AND ARV.CD_PROD = ARV2.CD_PROD)

	--ELIMINANDO OS REGISTROS POR PRODUTO
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_PROD TP
		WHERE
			T.CD_EMP = TP.CD_EMP
			AND T.CD_TBL_FIDEL = TP.CD_TBL_FIDEL
			AND ARV.CD_PROD = TP.CD_PROD)
	

UNION		

--PEGANDO A PONTUAO POR FABRICANTE
SELECT
	P.CD_PROD,
	TFIL.CD_FILIAL,
	T.CD_TBL_FIDEL,
	
	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	ELSE
		COALESCE(TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	END AS CD_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	ELSE
		COALESCE(TBL_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	END AS DS_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TIPO_PROMOCAO IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TIPO_PROMOCAO, 0)
	ELSE
		COALESCE(TBL_AD.CD_TIPO_PROMOCAO, 0)
	END AS CD_TIPO_PROMOCAO,

	CASE WHEN PROD_AD.CD_FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.CD_FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.CD_FATOR_PONTOS, 0)
	END AS TIPO_PONTUACAO,

	CASE WHEN PROD_AD.FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.FATOR_PONTOS, 0)
	END AS FATOR_PONTUACAO,

	CASE WHEN PROD_AD.VLR_MINIMO IS NOT NULL THEN
		COALESCE(PROD_AD.VLR_MINIMO, 0)
	ELSE
		COALESCE(TBL_AD.VLR_MINIMO, 0)
	END AS VLR_MINIMO,

	CASE WHEN PROD_AD.QTDE_MINIMA IS NOT NULL THEN
		COALESCE(PROD_AD.QTDE_MINIMA, 0)
	ELSE
		COALESCE(TBL_AD.QTDE_MINIMA, 0)
	END AS QTDE_MINIMA,

	CASE WHEN PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD_DIA.DIA, 0)
	ELSE
		COALESCE(TBL_AD_DIA.DIA, 0)
	END AS DIA_SEMANA,

	CASE WHEN PROD_AD.DT_INI IS NOT NULL THEN
		COALESCE(PROD_AD.DT_INI, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_INI, '20000101')
	END AS D1,

	CASE WHEN PROD_AD.DT_FIM IS NOT NULL THEN
		COALESCE(PROD_AD.DT_FIM, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_FIM, '20000101')
	END AS D2,

	CASE WHEN PROD_AD.CD_USU IS NOT NULL THEN
		COALESCE(PROD_AD.CD_USU, 0)
	ELSE
		COALESCE(TBL_AD.CD_USU, 0)
	END AS CD_USU,

	CASE WHEN PROD_AD.DT_CAD IS NOT NULL THEN
		COALESCE(PROD_AD.DT_CAD, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_CAD, '20000101')
	END AS DT_CAD,

	CASE WHEN PROD_AD.DT_ULT_ALT IS NOT NULL THEN
		COALESCE(PROD_AD.DT_ULT_ALT, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_ULT_ALT, '20000101')
	END AS DT_ULT_ALT
FROM
	EST_PROD_TBL_FIDEL T
	INNER JOIN EST_PROD_TBL_FIDEL_PRC_FILIAL TFIL ON
		T.CD_EMP = TFIL.CD_EMP
		AND T.CD_TBL_FIDEL = TFIL.CD_TBL_FIDEL
	INNER JOIN EST_PROD_TBL_FIDEL_EST_PROD_FABRIC TFAB ON
		T.CD_EMP = TFAB.CD_EMP
		AND T.CD_TBL_FIDEL = TFAB.CD_TBL_FIDEL
	INNER JOIN EST_PROD P ON
		TFAB.CD_EMP = P.CD_EMP
		AND TFAB.CD_FABRIC = P.CD_FABRIC
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL TBL_AD ON
		T.CD_EMP = TBL_AD.CD_EMP
		AND T.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA TBL_AD_DIA ON
		TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL PROD_AD ON
		TFAB.CD_EMP = PROD_AD.CD_EMP
		AND TFAB.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA PROD_AD_DIA ON
		PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
WHERE
	TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL OR PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL
	--ELIMINANDO OS REGISTROS POR MARCA
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_MC TM
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				TM.CD_EMP = ARV.CD_EMP
				AND TM.CD_MC = ARV.CD_MC
		WHERE
			T.CD_EMP = TM.CD_EMP
			AND T.CD_TBL_FIDEL = TM.CD_TBL_FIDEL
			AND P.CD_PROD = ARV.CD_PROD)

	--ELIMINANDO OS REGISTROS POR FAMILIA
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_ARV_MERC_FAMILIA TF
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV2 ON
				TF.CD_EMP = ARV2.CD_EMP
				AND TF.CD_ARV_MERC_FAMILIA = ARV2.CD_ARV_MERC_FAMILIA
				
		WHERE
			T.CD_EMP = TF.CD_EMP
			AND T.CD_TBL_FIDEL = TF.CD_TBL_FIDEL
			AND P.CD_PROD = ARV2.CD_PROD)

	--ELIMINANDO OS REGISTROS POR PRODUTO
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_PROD TP
		WHERE
			T.CD_EMP = TP.CD_EMP
			AND T.CD_TBL_FIDEL = TP.CD_TBL_FIDEL
			AND P.CD_PROD = TP.CD_PROD)



UNION		


--PEGANDO A PONTUAO POR CATEGORIA
SELECT
	ARV3.CD_PROD,
	TFIL.CD_FILIAL,
	T.CD_TBL_FIDEL,
	
	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	ELSE
		COALESCE(TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	END AS CD_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	ELSE
		COALESCE(TBL_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	END AS DS_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TIPO_PROMOCAO IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TIPO_PROMOCAO, 0)
	ELSE
		COALESCE(TBL_AD.CD_TIPO_PROMOCAO, 0)
	END AS CD_TIPO_PROMOCAO,

	CASE WHEN PROD_AD.CD_FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.CD_FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.CD_FATOR_PONTOS, 0)
	END AS TIPO_PONTUACAO,

	CASE WHEN PROD_AD.FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.FATOR_PONTOS, 0)
	END AS FATOR_PONTUACAO,

	CASE WHEN PROD_AD.VLR_MINIMO IS NOT NULL THEN
		COALESCE(PROD_AD.VLR_MINIMO, 0)
	ELSE
		COALESCE(TBL_AD.VLR_MINIMO, 0)
	END AS VLR_MINIMO,

	CASE WHEN PROD_AD.QTDE_MINIMA IS NOT NULL THEN
		COALESCE(PROD_AD.QTDE_MINIMA, 0)
	ELSE
		COALESCE(TBL_AD.QTDE_MINIMA, 0)
	END AS QTDE_MINIMA,

	CASE WHEN PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD_DIA.DIA, 0)
	ELSE
		COALESCE(TBL_AD_DIA.DIA, 0)
	END AS DIA_SEMANA,

	CASE WHEN PROD_AD.DT_INI IS NOT NULL THEN
		COALESCE(PROD_AD.DT_INI, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_INI, '20000101')
	END AS D1,

	CASE WHEN PROD_AD.DT_FIM IS NOT NULL THEN
		COALESCE(PROD_AD.DT_FIM, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_FIM, '20000101')
	END AS D2,

	CASE WHEN PROD_AD.CD_USU IS NOT NULL THEN
		COALESCE(PROD_AD.CD_USU, 0)
	ELSE
		COALESCE(TBL_AD.CD_USU, 0)
	END AS CD_USU,

	CASE WHEN PROD_AD.DT_CAD IS NOT NULL THEN
		COALESCE(PROD_AD.DT_CAD, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_CAD, '20000101')
	END AS DT_CAD,

	CASE WHEN PROD_AD.DT_ULT_ALT IS NOT NULL THEN
		COALESCE(PROD_AD.DT_ULT_ALT, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_ULT_ALT, '20000101')
	END AS DT_ULT_ALT
FROM
	EST_PROD_TBL_FIDEL T
	INNER JOIN EST_PROD_TBL_FIDEL_PRC_FILIAL TFIL ON
		T.CD_EMP = TFIL.CD_EMP
		AND T.CD_TBL_FIDEL = TFIL.CD_TBL_FIDEL
	INNER JOIN EST_PROD_TBL_FIDEL_EST_ARV_MERC_CATEGORIA TC ON
		T.CD_EMP = TC.CD_EMP
		AND T.CD_TBL_FIDEL = TC.CD_TBL_FIDEL
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV3 ON
		TC.CD_EMP = ARV3.CD_EMP
		AND TC.CD_ARV_MERC_CATEG = ARV3.CD_ARV_MERC_CATEG
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL TBL_AD ON
		T.CD_EMP = TBL_AD.CD_EMP
		AND T.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA TBL_AD_DIA ON
		TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL PROD_AD ON
		TC.CD_EMP = PROD_AD.CD_EMP
		AND TC.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA PROD_AD_DIA ON
		PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
WHERE
	TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL OR PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL
	--ELIMINANDO OS REGISTROS POR FABRICANTE
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_PROD_FABRIC TFAB
			INNER JOIN EST_PROD P ON
				TFAB.CD_EMP = P.CD_EMP
				AND TFAB.CD_FABRIC = P.CD_FABRIC
		WHERE
			T.CD_EMP = TFAB.CD_EMP
			AND T.CD_TBL_FIDEL = TFAB.CD_TBL_FIDEL
			AND ARV3.CD_PROD = P.CD_PROD)

	--ELIMINANDO OS REGISTROS POR MARCA
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_MC TM
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				TM.CD_EMP = ARV.CD_EMP
				AND TM.CD_MC = ARV.CD_MC
		WHERE
			T.CD_EMP = TM.CD_EMP
			AND T.CD_TBL_FIDEL = TM.CD_TBL_FIDEL
			AND ARV3.CD_PROD = ARV.CD_PROD)

	--ELIMINANDO OS REGISTROS POR FAMILIA
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_ARV_MERC_FAMILIA TF
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV2 ON
				TF.CD_EMP = ARV2.CD_EMP
				AND TF.CD_ARV_MERC_FAMILIA = ARV2.CD_ARV_MERC_FAMILIA
				
		WHERE
			T.CD_EMP = TF.CD_EMP
			AND T.CD_TBL_FIDEL = TF.CD_TBL_FIDEL
			AND ARV3.CD_PROD = ARV2.CD_PROD)

	--ELIMINANDO OS REGISTROS POR PRODUTO
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_PROD TP
		WHERE
			T.CD_EMP = TP.CD_EMP
			AND T.CD_TBL_FIDEL = TP.CD_TBL_FIDEL
			AND ARV3.CD_PROD = TP.CD_PROD)

	

UNION		

--PEGANDO A PONTUAO POR LINHA
SELECT
	ARV4.CD_PROD,
	TFIL.CD_FILIAL,
	T.CD_TBL_FIDEL,
	
	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	ELSE
		COALESCE(TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL, 0)
	END AS CD_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	ELSE
		COALESCE(TBL_AD.DS_TBL_FIDEL_PONTO_ADICIONAL, '')
	END AS DS_TBL_FIDEL_PONTO_ADICIONAL,

	CASE WHEN PROD_AD.CD_TIPO_PROMOCAO IS NOT NULL THEN
		COALESCE(PROD_AD.CD_TIPO_PROMOCAO, 0)
	ELSE
		COALESCE(TBL_AD.CD_TIPO_PROMOCAO, 0)
	END AS CD_TIPO_PROMOCAO,

	CASE WHEN PROD_AD.CD_FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.CD_FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.CD_FATOR_PONTOS, 0)
	END AS TIPO_PONTUACAO,

	CASE WHEN PROD_AD.FATOR_PONTOS IS NOT NULL THEN
		COALESCE(PROD_AD.FATOR_PONTOS, 0)
	ELSE
		COALESCE(TBL_AD.FATOR_PONTOS, 0)
	END AS FATOR_PONTUACAO,

	CASE WHEN PROD_AD.VLR_MINIMO IS NOT NULL THEN
		COALESCE(PROD_AD.VLR_MINIMO, 0)
	ELSE
		COALESCE(TBL_AD.VLR_MINIMO, 0)
	END AS VLR_MINIMO,

	CASE WHEN PROD_AD.QTDE_MINIMA IS NOT NULL THEN
		COALESCE(PROD_AD.QTDE_MINIMA, 0)
	ELSE
		COALESCE(TBL_AD.QTDE_MINIMA, 0)
	END AS QTDE_MINIMA,

	CASE WHEN PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL THEN
		COALESCE(PROD_AD_DIA.DIA, 0)
	ELSE
		COALESCE(TBL_AD_DIA.DIA, 0)
	END AS DIA_SEMANA,

	CASE WHEN PROD_AD.DT_INI IS NOT NULL THEN
		COALESCE(PROD_AD.DT_INI, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_INI, '20000101')
	END AS D1,

	CASE WHEN PROD_AD.DT_FIM IS NOT NULL THEN
		COALESCE(PROD_AD.DT_FIM, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_FIM, '20000101')
	END AS D2,

	CASE WHEN PROD_AD.CD_USU IS NOT NULL THEN
		COALESCE(PROD_AD.CD_USU, 0)
	ELSE
		COALESCE(TBL_AD.CD_USU, 0)
	END AS CD_USU,

	CASE WHEN PROD_AD.DT_CAD IS NOT NULL THEN
		COALESCE(PROD_AD.DT_CAD, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_CAD, '20000101')
	END AS DT_CAD,

	CASE WHEN PROD_AD.DT_ULT_ALT IS NOT NULL THEN
		COALESCE(PROD_AD.DT_ULT_ALT, '20000101')
	ELSE
		COALESCE(TBL_AD.DT_ULT_ALT, '20000101')
	END AS DT_ULT_ALT
FROM
	EST_PROD_TBL_FIDEL T
	INNER JOIN EST_PROD_TBL_FIDEL_PRC_FILIAL TFIL ON
		T.CD_EMP = TFIL.CD_EMP
		AND T.CD_TBL_FIDEL = TFIL.CD_TBL_FIDEL
	INNER JOIN EST_PROD_TBL_FIDEL_EST_ARV_MERC_LINHA TL ON
		T.CD_EMP = TL.CD_EMP
		AND T.CD_TBL_FIDEL = TL.CD_TBL_FIDEL
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV4 ON
		TL.CD_EMP = ARV4.CD_EMP
		AND TL.CD_ARV_MERC_LINHA = ARV4.CD_ARV_MERC_LINHA
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL TBL_AD ON
		T.CD_EMP = TBL_AD.CD_EMP
		AND T.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA TBL_AD_DIA ON
		TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = TBL_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL PROD_AD ON
		TL.CD_EMP = PROD_AD.CD_EMP
		AND TL.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL
	LEFT JOIN V_EST_PROD_TBL_FIDEL_PONTUACAO_ESPECIAL_DIA_SEMANA PROD_AD_DIA ON
		PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL = PROD_AD_DIA.CD_TBL_FIDEL_PONTO_ADICIONAL
WHERE
	TBL_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL OR PROD_AD.CD_TBL_FIDEL_PONTO_ADICIONAL IS NOT NULL
	--ELIMINANDO OS REGISTROS POR CATEGORIA
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_ARV_MERC_CATEGORIA TC
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV3 ON
				TC.CD_EMP = ARV3.CD_EMP
				AND TC.CD_ARV_MERC_CATEG = ARV3.CD_ARV_MERC_CATEG
		WHERE
			T.CD_EMP = TC.CD_EMP
			AND T.CD_TBL_FIDEL = TC.CD_TBL_FIDEL
			AND ARV4.CD_PROD = ARV3.CD_PROD)

	--ELIMINANDO OS REGISTROS POR FABRICANTE
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_PROD_FABRIC TFAB
			INNER JOIN EST_PROD P ON
				TFAB.CD_EMP = P.CD_EMP
				AND TFAB.CD_FABRIC = P.CD_FABRIC
		WHERE
			T.CD_EMP = TFAB.CD_EMP
			AND T.CD_TBL_FIDEL = TFAB.CD_TBL_FIDEL
			AND ARV4.CD_PROD = P.CD_PROD)

	--ELIMINANDO OS REGISTROS POR MARCA
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_MC TM
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
				TM.CD_EMP = ARV.CD_EMP
				AND TM.CD_MC = ARV.CD_MC
		WHERE
			T.CD_EMP = TM.CD_EMP
			AND T.CD_TBL_FIDEL = TM.CD_TBL_FIDEL
			AND ARV4.CD_PROD = ARV.CD_PROD)

	--ELIMINANDO OS REGISTROS POR FAMILIA
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_ARV_MERC_FAMILIA TF
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV2 ON
				TF.CD_EMP = ARV2.CD_EMP
				AND TF.CD_ARV_MERC_FAMILIA = ARV2.CD_ARV_MERC_FAMILIA
				
		WHERE
			T.CD_EMP = TF.CD_EMP
			AND T.CD_TBL_FIDEL = TF.CD_TBL_FIDEL
			AND ARV4.CD_PROD = ARV2.CD_PROD)

	--ELIMINANDO OS REGISTROS POR PRODUTO
	AND NOT EXISTS (
		SELECT
			*
		FROM
			EST_PROD_TBL_FIDEL_EST_PROD TP
		WHERE
			T.CD_EMP = TP.CD_EMP
			AND T.CD_TBL_FIDEL = TP.CD_TBL_FIDEL
			AND ARV4.CD_PROD = TP.CD_PROD)



GO


